﻿<%@ Control Language="C#" AutoEventWireup="True" Inherits="VIRP_WEB.Controls.Custom.EFR.AddressEntry" Codebehind="AddressEntry.ascx.cs" %>
    
    <style type="text/css">
        .style3
            {
                width: 300px;
            }
    </style>

    <script src="../scripts/jquery-1[1].3.2.js" type="text/javascript"></script>

    <script type = "text/javascript">

        $(document).ready(function()
        {
            $('.pcpInfoClass').click(function()
            {
                var lines = $('input[id *=hdfPCPInfoField]').val().split("|");          
                fillAddress(this, lines);
            });

            $('.vamcInfoClass').click(function()
            {
                var lines = $('input[id *=hdfVAMCInfoField]').val().split("|");
                fillAddress(this, lines);
            });

            $('.primInfoClass').click(function() 
            {                
                var lines = $('input[id *=hdfPrimaryAddress]').val().split("|");
                fillAddress(this, lines);
            });

            $('.secInfoClass').click(function() 
            {
                var lines = $('input[id *=hdfAlternateAddress]').val().split("|");
                fillAddress(this, lines);
            });
        });

        var fillAddress = function (control, lines) {

            var index = 0;

            setAddressPart(control, lines[index++], 'Name');

            if (lines.length == 10) {
                setAddressPart(control, lines[index++], 'FacilityName');
            }

            setAddressPart(control, lines[index++], 'AddressPart1');
            setAddressPart(control, lines[index++], 'AddressPart2');
            setAddressPart(control, lines[index++], 'AddressPart3');
            setAddressPart(control, lines[index++], 'City');
            setAddressPart(control, lines[index++], 'State');
            setAddressPart(control, lines[index++], 'Zip');
            setAddressPart(control, lines[index++], 'Country');
            setAddressPart(control, lines[index], 'Phone');
        }

        var setAddressPart = function (control, entry, name) {

            if (entry != name) {
                $(control).closest('table.main').find('input[id*=txt' + name + ']').val(entry);
            } else {
                $(control).closest('table.main').find('input[id*=txt' + name + ']').val('');
            }
        }

    </script>

    <table class="main">
        <tr>
            <td style = "width:50%;padding-left:2px" class = "pcpSection" >
                <asp:Panel ID = "PCPInfoPanel" runat = "server" GroupingText = "&nbsp;Primary Care Physician&nbsp;"   >
                    
                    <asp:Label SkinID="DataLabel" ID = "PCPInfoLabel" runat = "server"></asp:Label> 
                    
                    <br />
                    <input type = "button" id = "PCPInfoButton" value = "Send to PCP" class = "pcpInfoClass" style = "width:125px" />            
                    <asp:HiddenField ID = "hdfPCPInfoField" runat = "server" />
                </asp:Panel>
            
            </td>
            <td style = "width:50%;padding-left:2px;" class = "vamcSection">
                <asp:Panel ID = "VAMCInfoPanel" runat = "server" GroupingText = "&nbsp;Local VAMC Contact&nbsp;" >
                    
                    <asp:Label SkinID="DataLabel" ID = "VAMCInfoLabel" runat = "server"></asp:Label>
                    <br />
                    <input type = "button" id = "VAMCInfoButton" class = "vamcInfoClass" value = "Send to Contact" style = "width:125px" />    
                    <asp:HiddenField ID = "hdfVAMCInfoField" runat = "server" /> 
                </asp:Panel>
            </td>
        </tr>
     
        <tr>
            <td style = "width:50%;padding-left:2px" class = "primSection" >
                <asp:Panel ID = "PrimaryAddressPanel" runat = "server" GroupingText = "&nbsp;Primary Patient Address&nbsp;"   >
                    
                    <asp:Label SkinID="DataLabel" ID = "PrimaryAddressLabel" runat = "server"></asp:Label> 
                    
                    <br />
                    <input type = "button" id = "PrimaryAddressButton" value = "Use Primary Address" class = "primInfoClass" style = "width:145px;" />            
                    <asp:HiddenField ID = "hdfPrimaryAddress" runat = "server" />
                </asp:Panel>
            
            </td>
            <td style = "width:50%;padding-left:2px;" class = "altSection">
                <asp:Panel ID = "AlternateAddressPanel" runat = "server" GroupingText = "&nbsp;Alternate Patient Address&nbsp;" >
                    
                    <asp:Label SkinID="DataLabel" ID = "AlternateAddressLabel" runat = "server"></asp:Label>
                    <br />
                    <input type = "button" id = "AlternateAddressButton" class = "secInfoClass" value = "Use Alternate Address" style = "width:145px" />    
                    <asp:HiddenField ID = "hdfAlternateAddress" runat = "server" /> 
                </asp:Panel>
            </td>
        </tr>
     
        <tr>
        <td colspan = "2">
            <asp:Panel ID = "InterpretationSectionPanel" runat = "server"> 
            <table>
            <tr>
                <td class="style3">
                    <asp:Label runat="server" ID="label14" Text="Name:" AssociatedControlID="txtName" SkinID = "DataLabel"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtName" runat="server" Width="400px"></asp:TextBox><asp:Label ID="lblName" runat="server" Width="400px" Visible="false" SkinID = "DataLabel"></asp:Label>
                </td>
            </tr>
            <tr class = "facility">
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="labelFacilityName" Text="Facility Name:" AssociatedControlID="txtFacilityName"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtFacilityName" runat="server" Width="400px"></asp:TextBox>
                </td>
                
            </tr>            
            <tr>
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="label1" Text="Address Part1:" AssociatedControlID="txtAddressPart1"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtAddressPart1" runat="server" Width="400px" MaxLength="100"></asp:TextBox>
                    <asp:CustomValidator ID="CustomValidator1" runat="server" 
                        ErrorMessage="Address Part1 can not be empty." 
                        onservervalidate="CustomValidator1_ServerValidate" SetFocusOnError="True"></asp:CustomValidator>
                </td>
            </tr>
            <tr>
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="label15" Text="Address Part2:" AssociatedControlID="txtAddressPart2"></asp:Label></td>
                <td style="margin-left: 40px">
                    <asp:TextBox ID="txtAddressPart2" runat="server" width="400px" MaxLength="100"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="label3" Text="Address Part3:" AssociatedControlID="txtAddressPart3"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtAddressPart3" runat="server" width="400px" MaxLength="100"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="label17" Text="City:" AssociatedControlID="txtCity"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtCity" runat="server" width="400px" MaxLength="60"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="label16" Text="State:" AssociatedControlID="txtState"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtState" runat="server" MaxLength="50"></asp:TextBox>
                </td>
                
            </tr>
            <tr>
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="label18" Text="Zip:" AssociatedControlID="txtZip"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtZip" runat="server" MaxLength="20"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="label11" Text="Country:" AssociatedControlID="txtCountry"></asp:Label></td>
                <td>
                    <asp:TextBox ID="txtCountry" runat="server" MaxLength="50"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td class="style3">
                    <asp:Label SkinID="DataLabel" runat="server" ID="Telephone" 
                        Text="Telephone Number:" 
                        AssociatedControlID="txtPhone">
                    </asp:Label>
                </td>
                <td>
                    <asp:TextBox ID="txtPhone" runat="server" >
                    </asp:TextBox>
                </td>
            </tr>
            </table>
            </asp:Panel>
            </td>
        </tr>
        </table>
        